//#######################################################################################################################
//#
//#	     
//#
//#######################################################################################################################

//----------------------------------------------------------------------------------------------
//    
// 1 -  
// 2 -  (0 -   , 1-8 -  , 9 -   )
//    ,      
void LedBoardSimbPrint (unsigned char simbol, unsigned char position)
{
	if (position > (LedBoardSize+1))
		return;

	char* pPosition = position * LedBoardSimbWidth + LedBoardBuffer;//       

	if (simbol < 0x20)
		simbol = 0x20;
	if (simbol >= 0xc0)
		simbol -= 0x40;
	char *pSimbol = (simbol - 0x20) * FontSimbWidth + SimbMass;		//       
		
	for (char i=0; i<FontSimbWidth; i++)							// 
		*pPosition++ = pgm_read_byte (pSimbol++);
	for (char i=0; i<(LedBoardSimbWidth-FontSimbWidth); i++)		//  
		*pPosition++ = 0;
}


//-----------------------------------------------------------------------------------------------------------------------
//     
// -      PROGMEM
void LedBoardMessageShow (char *pAdrTxt)
{
	unsigned char position = 1;
	while (1){
		if (position > LedBoardSize)
			return;											//   	
		char byte = pgm_read_byte (pAdrTxt++);
		if (! byte)
			return;											//   
		LedBoardSimbPrint (byte, position++);				// 
	} 
}


//-----------------------------------------------------------------------------------------------------------------------
//      (    )
// -      PROGMEM
void LedBoardMessageScrollLeft (char *pAdrTxt)
{
	while (1){
		char byte = pgm_read_byte (pAdrTxt++);
		if (! byte)											//   
			return;

		LedBoardSimbPrint (byte, LedBoardSize+1);			//    

		for (char i=0; i<LedBoardSimbWidth; i++)			//   
			LedBoard1PixScrollLeft ();	
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//    -    
void LedBoardClearScrollLeft (void)
{
	LedBoardSimbPrint (' ', LedBoardSize+1);
	unsigned char Length = LedBoardSize * LedBoardSimbWidth;//   
	for (char i=0; i<Length; i++)
		LedBoard1PixScrollLeft ();	
}


//     1 ,    
void LedBoard1PixScrollLeft (void)
{
	unsigned char speed = 100/LedBoardHorScrollSpeed;			//   (1-100 \)	
	for (char z=0; z<speed; z++){	
		while (! (Flags1 & b1LedBoardPageCompleted)){}			//   
		Flags1 &= ~b1LedBoardPageCompleted;						// 
	}

	char* pLineBuf1 = LedBoardBuffer+LedBoardSimbWidth;			//    
	char* pLineBuf2 = LedBoardBuffer+LedBoardSimbWidth+1;		// 
	unsigned char Length = (LedBoardSize+1)*LedBoardSimbWidth-1;//  
	for (char z=0; z<Length; z++)								//    
		*pLineBuf1++ = *pLineBuf2++;
	*pLineBuf1 = 0;

	if (ClockPosition)											//   ( )
		ClockPosition--;
}


//-----------------------------------------------------------------------------------------------------------------------
//    
void LedBoardClearScrollDown (void)
{
	ClockPosition = 0;											//    (  )
	unsigned char speed = 100/LedBoardVertScrollSpeed;			//   (1-100 \)	
	for (char i=0; i<8; i++){
		for (char z=0; z<speed; z++){	
			while (! (Flags1 & b1LedBoardPageCompleted)){}		//   
			Flags1 &= ~b1LedBoardPageCompleted;					// 
		}
		
		char* pBufPtr = LedBoardBuffer+LedBoardSimbWidth;		//    
		unsigned char Length = LedBoardSize*LedBoardSimbWidth;	//  
	
		for (char z=0; z<Length; z++){
			char temp = *pBufPtr;
			temp >>= 1;
			*pBufPtr++ = temp;
		}
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//     
// 1 -       (0-      , 1-8  , 9-  )
// 2 -      (0,1)

char TxtError	[] PROGMEM = "   ERROR";

void LedBoardTermoShow (char Position, uint8_t NumDev)
{
	if (OneWireErr & (1<<NumDev))
		LedBoardMessageShow (TxtError);							//   
	else{
		LedBoardSimbPrint (' ', Position);						//  
		LedBoardIntPrint(OneWireTermoData[NumDev],Position+1, 5, 1);
		if ((Position+6) <= (LedBoardSize+1))
			LedBoardSimbPrint ('`', Position+6);
		if ((Position+7) <= (LedBoardSize+1))
			LedBoardSimbPrint ('C', Position+7);
	}
}


//       C 
// -      (0,1)
void LedBoardTermoScrollLeft (uint8_t NumDev)
{
	if (OneWireErr & (1<<NumDev))
		LedBoardMessageScrollLeft (TxtError);					//   
	else{
		for (char i=9; i>1; i--){								//     
			LedBoardTermoShow (i, NumDev);						
			for (char x=0; x<LedBoardSimbWidth; x++)			//   
				LedBoard1PixScrollLeft ();	
		}
	}
}


//----------------------------------------------------------------------------------------------
//     LedBoard
// 1 -      (1-9)
void LedBoardClockShow (uint8_t Position)
{
	if ((Position > 0) && (Position <= LedBoardSize+1))
		ClockPosition = (Position +7) * LedBoardSimbWidth;
}


//----------------------------------------------------------------------------------------------
//      
void LedBoardClockScrollLeft (void)
{
	LedBoardClockShow (9);
	LedBoardClearScrollLeft ();
}


//-----------------------------------------------------------------------------------------------------------------------
//  X 
// -   
NOINLINE void Delay (unsigned char second)
{
	for (unsigned char i=0; i<second; i++)		//   	
		_delay_ms (1000);
}


//-----------------------------------------------------------------------------------------------------------------------
//  16-    LcdBoard ( ..     )
// 1 - 16-  
// 2 -      LcdBoard (0-  , 1-8- , 9-  )  
// 3 -   (1-8)  (-     )
// 4 -     (0- , 1-   , 2- , ...)

void LedBoardIntPrint (signed int integer, uint8_t IntPos, uint8_t IntLength, uint8_t DotPosition)
{												
	char IntBuf [IntLength];					//   
	char* pIntBuf = IntBuf+IntLength-1; 		//  
	uint8_t DigitCoun = 0;						//  

	uint8_t negative = 0;						//  
	if (integer < 0){							
		integer ^= 0xffff;
		integer++;
		negative = 1;									
	}

	for (uint8_t i=0; i<IntLength; i++){		//   
		*pIntBuf-- = integer %10+0x30;			//  
		integer /= 10;							//  10
		DigitCoun ++;
		if (! integer)
			break;
	}
			
	if (DotPosition){							//   - 
		while (DotPosition > DigitCoun){		//  
			*pIntBuf-- = 0x30;				
			DigitCoun++;
		}
												
		if (DotPosition == DigitCoun){			//     
			*pIntBuf-- = '.'; 
			*pIntBuf-- = 0x30;	
			DigitCoun += 2;
			goto m1;
		} 
		
		// if (DotPos < DigitCoun) 				//    ,   
		char *pMoveCntr = pIntBuf--;			//       
		char MoveVal = DigitCoun-DotPosition;	//-   
		for (char i=0; i<MoveVal; i++){
			char temp = *(pMoveCntr+1);
			*pMoveCntr++ = temp;
		}

		*pMoveCntr = '.';						// 
		DigitCoun++;
	}

m1:	if (negative){								//   ,  "-"
		*pIntBuf-- = '-'; 
		DigitCoun++;
	}

	while (DigitCoun++ < IntLength)				//       -    
		*pIntBuf-- = 0x20;

	for (uint8_t i=0; i<IntLength; i++){		//     -   
		if ((IntPos+i) <= (LedBoardSize+1))
			LedBoardSimbPrint (IntBuf [i], IntPos+i);
	}
}


//#######################################################################################################################
//#
//#	   1WIRE
//#
//#######################################################################################################################

//      1WIRE
// -   
void OneWireReset (char mask)
{
	OneWireDDR |= (mask);						//  
	_delay_us (480);

	OneWireDDR &= ~(mask);						//  
	_delay_us (480); 
}


//-----------------------------------------------------------------------------------------------------------------------
//    1WIRE
// 1 -   
// 2 -   
// -    
//      - (    ,    0xff)

unsigned char OneWireData (unsigned char OutByte, char mask)
{
	char InByte =0;								//    

	for (unsigned char i = 0; i<8; i++){
		//\   1wire
		InByte >>= 1;
		cli ();
		OneWireDDR |= mask;						// 
		if (OutByte & 0x01){
			// 1
			_delay_us (5);				
			OneWireDDR &= ~mask;				// 
			_delay_us (5);
	
			if (OneWirePIN & mask)				//   1wire 
				InByte |= 0x80;					//  = 1
			sei ();

			_delay_us (70);
		}
		else{
			// 0
			_delay_us (75);				
			OneWireDDR &= ~mask;				// 
			sei ();
			_delay_us (5);
		}

		OutByte >>= 1;
	}
	CheckSumm (InByte);							//  
	return InByte;
}


//-----------------------------------------------------------------------------------------------------------------------
//   
// -      
//OneWireCheckSumm -    
//     
//       0
void CheckSumm(char data)
{
	for (char i=0; i<8; i++){
		char temp = data;
		temp ^= OneWireCheckSumm;

		if (temp & 0x01){
			OneWireCheckSumm ^= 0x18;
			temp = 0x80;
		}
		else
			temp = 0;

		OneWireCheckSumm >>= 1;
		OneWireCheckSumm |= temp;
		data >>= 1;
	}
}


//#######################################################################################################################
//#
//#	    DS1307
//#
//#######################################################################################################################

//       DS1307
//     ClockData[7]
//  - [0], [1], [2], [3], [4], [5], [6]
void IICClockReadData (void)
{
	IICStart();
	IICByteWrite (0xD0);						//   DS1307
	IICByteWrite (0x00);						//   DS1307  0 

	IICStart();
	IICByteWrite (0xD1);						//   

	char temp;									//     
	char Accumulate = 0;						//     
	char NumBit = (1<<0);						//      
	char* pClockData = ClockData;				//   

	for (char i = 0; i<6; i++){					//    
		temp = IICByteRead (0);					//, , , , , ,  (   (0))

		if (i == 0){							//   ,    
			if (temp != *pClockData){	
				Flags1 |= b1ClockChange;		//     
				ClockMiliSecond = 0;			// 		
			}
		}

		if (i < 3){								//    
			if ((temp & 0x0F) != (*pClockData & 0x0F))// ,   
				Accumulate |= NumBit;
			NumBit <<= 1;
			if ((temp & 0xF0) != (*pClockData & 0xF0))// ,   
				Accumulate |= NumBit;
			NumBit <<= 1;
		}

		*pClockData++ = temp;					// - , , , , 
	}
	*pClockData = IICByteRead (1);				//  ( )
	IICStop(); 

	ClockChangeMask |= Accumulate;				//   
}


//       DS1307
//     ClockData[7]
//  - [0], [1], [2], [3], [4], [5], [6]
void IICClockWriteData (void)
{
	IICStart();
	IICByteWrite (0xD0);					//   DS1307
	IICByteWrite (0x00);					//   DS1307  0 

	for (unsigned char i = 0; i<7; i++)
		IICByteWrite (ClockData [i]);		//, , , , , , , 

	IICStop();
}


//  \   
// - - 
// -  
char ConvBinDecToHex (char byte)
{				
	char result = 10 * (byte >> 4);
	result += (byte & 0x0f);
	return result; 
}


//     \
// -  
// - - 
char ConvHexToBinDec (char byte){
	char result = byte %10;
	result |= ((byte/10) << 4);
	return result; 
}


//#######################################################################################################################
//#
//#    I2C ( )
//#
//#######################################################################################################################

// 2      IIC
NOINLINE void Delay2Mks (void)
{
	_delay_us (2);
}


//   START   IIC
void IICStart (void)
{
	IICDDR &= ~(IICData | IICClc);
	Delay2Mks();

	IICDDR |= IICData;							// data  
	Delay2Mks();

	IICDDR |= IICClc;							// clc  
	Delay2Mks();			
}


//   STOP   IIC
void IICStop (void)
{
	IICDDR |= (IICData | IICClc);
	Delay2Mks();

	IICDDR &= ~IICClc;							// data  
	Delay2Mks();

	IICDDR &= ~IICData;							// clc  
	Delay2Mks();			
}


//     IIC
// -      IIC
// -   0 ( )  1 ( ) 
char IICByteWrite (char byte)
{
	for (char i = 0; i<8; i++)
		byte = IICBit (byte);

	byte = 0x80;								
	return IICBit (byte);						//   (0-  , 1-)
}


//     IIC
// -    (0 -  , 1 -  )
// -  
char IICByteRead (char bit)
{
	char byte = 0xFF;
	for (char i = 0; i<8; i++)
		byte = IICBit (byte);

	bit <<= 7;
	IICBit (bit);								//   
	return byte;								//  
}


// \    IIC
//    
//         
char IICBit (char byte)						
{
	if (byte & 0x80)						// 
		IICDDR &= ~IICData; 				// 1   
	else 
		IICDDR |= IICData;					// 0   
	Delay2Mks();

	IICDDR &= ~IICClc;						//  
	while (! (IICPIN & IICClc)){}			//  
	Delay2Mks();

	char temp;	
	if (IICPIN & IICData)					// 
		temp = 1;
	else
		temp = 0;
	IICDDR |= IICClc;						// 

	byte <<= 1;
	byte |= temp;
	return byte;
}


//#######################################################################################################################
//#
//# end
//#
//#######################################################################################################################
